<?php

namespace QuadLayers\IGG_PRO;

final class Plugin {

	protected static $instance;

	private function __construct() {
		/**
		 * Load plugin textdomain.
		 */
		load_plugin_textdomain( 'insta-gallery-pro', false, QLIGG_PRO_PLUGIN_DIR . '/languages/' );

		if ( ! class_exists( 'QuadLayers\\IGG\\Plugin', false ) ) {
			return;
		}

		Api\Ajax\Ajax_Library::instance();
		Api\Rest\Routes_Library::instance();
		Backend\Load::instance();
		Frontend\Load::instance();
	}

	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

}
add_action(
	'plugins_loaded',
	function() {
		Plugin::instance();
	}
);
